(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     53613,       1400]
NotebookOptionsPosition[     52568,       1361]
NotebookOutlinePosition[     52912,       1376]
CellTagsIndexPosition[     52869,       1373]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{"Ose", ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"-", "10"}], ",", "0"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "t", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "t", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"-", "10"}], ",", "0"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "t"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "t"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"-", "10"}], ",", "0"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Elipsoid", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_", ",", "a_", ",", "b_", ",", "c_"}], 
   "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "+", 
         RowBox[{"a", "*", 
          RowBox[{"Cos", "[", "t", "]"}], 
          RowBox[{"Sin", "[", "u", "]"}]}]}], ",", 
        RowBox[{"y", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", "t", "]"}], 
          RowBox[{"Sin", "[", "u", "]"}]}]}], ",", 
        RowBox[{"z", "+", 
         RowBox[{"c", "*", 
          RowBox[{"Cos", "[", "u", "]"}]}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", 
        RowBox[{"-", "0"}], ",", "Pi"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "White"}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", 
        RowBox[{"z", "*", "t"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"y", "*", "t"}], ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"z", "*", "t"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "y", ",", 
        RowBox[{"z", "*", "t"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "y", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "0", ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "y", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"y", "*", "t"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"y", "*", "t"}], ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Paraboloid", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_", ",", "a_"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "+", "u"}], ",", 
        RowBox[{"y", "+", "v"}], ",", 
        RowBox[{"z", "+", 
         RowBox[{"a", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"u", "^", "2"}], "+", 
            RowBox[{"v", "^", "2"}]}], ")"}]}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"v", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "White"}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", 
        RowBox[{"z", "*", "t"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"y", "*", "t"}], ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"z", "*", "t"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "y", ",", 
        RowBox[{"z", "*", "t"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "y", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "0", ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "y", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"y", "*", "t"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"y", "*", "t"}], ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Hiperboloid", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_", ",", "a_"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "+", "u"}], ",", 
        RowBox[{"y", "+", "v"}], ",", 
        RowBox[{"z", "+", 
         RowBox[{"a", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"u", "^", "2"}], "-", 
            RowBox[{"v", "^", "2"}]}], ")"}]}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"v", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "White"}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", 
        RowBox[{"z", "*", "t"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"y", "*", "t"}], ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"z", "*", "t"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "y", ",", 
        RowBox[{"z", "*", "t"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "y", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "0", ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "y", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"y", "*", "t"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"y", "*", "t"}], ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ParCilindar", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_", ",", "a_"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "+", "u"}], ",", 
        RowBox[{"y", "+", "v"}], ",", 
        RowBox[{"z", "+", 
         RowBox[{"a", "*", 
          RowBox[{"u", "^", "2"}]}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"v", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "White"}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"y", "*", "t"}], ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"z", "*", "t"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "y", ",", 
        RowBox[{"z", "*", "t"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "y", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "0", ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "y", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"y", "*", "t"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"y", "*", "t"}], ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Cilindar", "[", 
   RowBox[{"x_", ",", "y_", ",", "a_", ",", "b_"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "+", 
         RowBox[{"a", "*", 
          RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
        RowBox[{"y", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", "t", "]"}]}]}], ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "White"}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "y", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "y", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "y", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"y", "*", "t"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"y", "*", "t"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Konus", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_", ",", "a_", ",", "b_", ",", "c_"}], 
   "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "+", "u"}], ",", 
        RowBox[{"y", "+", "v"}], ",", 
        RowBox[{"c", 
         SqrtBox[
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"u", "^", "2"}]}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"v", "^", "2"}]}]}]]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"v", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "White"}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "+", "u"}], ",", 
        RowBox[{"y", "+", "v"}], ",", 
        RowBox[{
         RowBox[{"-", "c"}], 
         SqrtBox[
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"u", "^", "2"}]}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"v", "^", "2"}]}]}]]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"v", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "White"}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"y", "*", "t"}], ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"z", "*", "t"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "y", ",", 
        RowBox[{"z", "*", "t"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "y", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "0", ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "*", "t"}], ",", "y", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"y", "*", "t"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"y", "*", "t"}], ",", "z"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", "Dashed"}], "}"}]}]}], "]"}]}], 
   "}"}]}]}], "Input",
 CellChangeTimes->{{3.528389367703125*^9, 3.528389589390625*^9}, {
   3.528389651640625*^9, 3.5283896540625*^9}, {3.528389857859375*^9, 
   3.528389950109375*^9}, {3.52838999296875*^9, 3.528390004203125*^9}, {
   3.528390047203125*^9, 3.528390050953125*^9}, {3.5283901301875*^9, 
   3.52839017575*^9}, {3.528390212890625*^9, 3.5283902131875*^9}, {
   3.5283902491875*^9, 3.52839026734375*^9}, {3.528390317203125*^9, 
   3.528390399578125*^9}, {3.5596269238093348`*^9, 3.559626943716473*^9}, {
   3.559626974017206*^9, 3.5596271017015095`*^9}, {3.5596275415896697`*^9, 
   3.559627557068555*^9}, {3.5596275910845003`*^9, 3.5596276659447823`*^9}, {
   3.5596277006007643`*^9, 3.559627711828407*^9}, {3.5596277630853386`*^9, 
   3.5596277648874416`*^9}, {3.5596278891495485`*^9, 3.559627981497831*^9}, 
   3.559628039250134*^9, {3.55962809163113*^9, 3.559628141525984*^9}, {
   3.559628216916296*^9, 3.5596282665961375`*^9}, 3.5596283173310394`*^9, {
   3.5596283876990643`*^9, 3.5596284660525455`*^9}, {3.5596289049666505`*^9, 
   3.559628978449853*^9}, {3.559629075829423*^9, 3.5596291108664274`*^9}, {
   3.570822028602155*^9, 3.570822030041238*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", " ", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{"Ose", ",", 
     RowBox[{"Elipsoid", "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "a", ",", "b", ",", "c"}], "]"}], 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.528389593203125*^9, 3.528389614953125*^9}, {
  3.528389941578125*^9, 3.528389978515625*^9}, {3.528390054609375*^9, 
  3.528390081640625*^9}, {3.528390145203125*^9, 3.5283901453125*^9}, {
  3.52839027734375*^9, 3.528390277671875*^9}, {3.5596271084918976`*^9, 
  3.559627169911411*^9}, {3.5596272009301853`*^9, 3.5596272321119685`*^9}, {
  3.5596272754984503`*^9, 3.559627456487802*^9}, {3.570822073214707*^9, 
  3.5708220768099127`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 1, $CellContext`b$$ = 
    1, $CellContext`c$$ = 1, $CellContext`x$$ = 0, $CellContext`y$$ = 
    0, $CellContext`z$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 0, 1}, {
      Hold[$CellContext`z$$], 0, 1}, {
      Hold[$CellContext`a$$], 1, 3}, {
      Hold[$CellContext`b$$], 1, 3}, {
      Hold[$CellContext`c$$], 1, 3}}, Typeset`size$$ = {360., {193., 198.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$10501$$ = 0, $CellContext`y$10502$$ = 
    0, $CellContext`z$10503$$ = 0, $CellContext`a$10504$$ = 
    0, $CellContext`b$10505$$ = 0, $CellContext`c$10506$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 1, $CellContext`b$$ = 
        1, $CellContext`c$$ = 1, $CellContext`x$$ = 0, $CellContext`y$$ = 
        0, $CellContext`z$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$10501$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$10502$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$10503$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$10504$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$10505$$, 0], 
        Hold[$CellContext`c$$, $CellContext`c$10506$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[$CellContext`Ose, 
        $CellContext`Elipsoid[$CellContext`x$$, $CellContext`y$$, \
$CellContext`z$$, $CellContext`a$$, $CellContext`b$$, $CellContext`c$$], 
        PlotRange -> {{-4, 4}, {-4, 4}, {-4, 4}}, Boxed -> False, Axes -> 
        False], "Specifications" :> {{$CellContext`x$$, 0, 
         1}, {$CellContext`y$$, 0, 1}, {$CellContext`z$$, 0, 
         1}, {$CellContext`a$$, 1, 3}, {$CellContext`b$$, 1, 
         3}, {$CellContext`c$$, 1, 3}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{409., {307., 312.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.52838961734375*^9, 3.528389656953125*^9, {3.5283899430625*^9, 
   3.528390008046875*^9}, {3.5283900561875*^9, 3.528390082703125*^9}, {
   3.5283901400625*^9, 3.528390178546875*^9}, 3.5283902781875*^9, 
   3.52839037634375*^9, 3.52839041003125*^9, 3.5596271716965127`*^9, {
   3.559627213795921*^9, 3.559627233159028*^9}, {3.559627349071658*^9, 
   3.5596273708109016`*^9}, 3.5596274025577173`*^9, {3.559627433428483*^9, 
   3.559627457223844*^9}, 3.5596289907085543`*^9, 3.570822147845976*^9, 
   3.5708302799541054`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", " ", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{"Ose", ",", 
     RowBox[{"Paraboloid", "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "a"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "2", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.559627515000149*^9, 3.559627515912201*^9}, {
  3.5596276472897153`*^9, 3.559627686639966*^9}, {3.5596277219679866`*^9, 
  3.5596277350397344`*^9}, {3.5596277964262457`*^9, 3.559627796655258*^9}, {
  3.5708220886255884`*^9, 3.5708221046495047`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 2, $CellContext`x$$ = 
    0, $CellContext`y$$ = 0, $CellContext`z$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 0, 1}, {
      Hold[$CellContext`z$$], 0, 1}, {
      Hold[$CellContext`a$$], 2, -2}}, Typeset`size$$ = {360., {193., 198.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$10702$$ = 0, $CellContext`y$10703$$ = 
    0, $CellContext`z$10704$$ = 0, $CellContext`a$10705$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 2, $CellContext`x$$ = 
        0, $CellContext`y$$ = 0, $CellContext`z$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$10702$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$10703$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$10704$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$10705$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[$CellContext`Ose, 
        $CellContext`Paraboloid[$CellContext`x$$, $CellContext`y$$, \
$CellContext`z$$, $CellContext`a$$], PlotRange -> {{-4, 4}, {-4, 4}, {-4, 4}},
         Boxed -> False, Axes -> False], 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, {$CellContext`y$$, 0, 
         1}, {$CellContext`z$$, 0, 1}, {$CellContext`a$$, 2, -2}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{409., {280., 285.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.5596277974213023`*^9, 3.5596289947477856`*^9, 
  3.5708221504941273`*^9, 3.5708302837953253`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.559627771640828*^9, 3.559627841835843*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.559627775603054*^9, 3.559627775646057*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", " ", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{"Ose", ",", 
     RowBox[{"Hiperboloid", "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "a"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "2", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5596278709265065`*^9, 3.5596278719105625`*^9}, {
   3.559628007057293*^9, 3.5596280168798547`*^9}, 3.570822110473838*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 2, $CellContext`x$$ = 
    0, $CellContext`y$$ = 0, $CellContext`z$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 0, 1}, {
      Hold[$CellContext`z$$], 0, 1}, {
      Hold[$CellContext`a$$], 2, -2}}, Typeset`size$$ = {360., {193., 198.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$10821$$ = 0, $CellContext`y$10822$$ = 
    0, $CellContext`z$10823$$ = 0, $CellContext`a$10824$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 2, $CellContext`x$$ = 
        0, $CellContext`y$$ = 0, $CellContext`z$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$10821$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$10822$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$10823$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$10824$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[$CellContext`Ose, 
        $CellContext`Hiperboloid[$CellContext`x$$, $CellContext`y$$, \
$CellContext`z$$, $CellContext`a$$], PlotRange -> {{-4, 4}, {-4, 4}, {-4, 4}},
         Boxed -> False, Axes -> False], 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, {$CellContext`y$$, 0, 
         1}, {$CellContext`z$$, 0, 1}, {$CellContext`a$$, 2, -2}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{409., {280., 285.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.5596278725526*^9, {3.559628017640898*^9, 3.559628046202532*^9}, 
   3.559628997848963*^9, 3.5708221523732347`*^9, 3.5708302857474365`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", " ", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{"Ose", ",", 
     RowBox[{"ParCilindar", "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "a"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "2", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.559628076279252*^9, 3.559628077734335*^9}, {
   3.5596281614091215`*^9, 3.559628168103504*^9}, {3.5596283405523677`*^9, 
   3.5596283442075768`*^9}, 3.57082211452907*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 2, $CellContext`x$$ = 
    0, $CellContext`y$$ = 0, $CellContext`z$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 0, 1}, {
      Hold[$CellContext`z$$], 0, 1}, {
      Hold[$CellContext`a$$], 2, -2}}, Typeset`size$$ = {360., {193., 198.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$10946$$ = 0, $CellContext`y$10947$$ = 
    0, $CellContext`z$10948$$ = 0, $CellContext`a$10949$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 2, $CellContext`x$$ = 
        0, $CellContext`y$$ = 0, $CellContext`z$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$10946$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$10947$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$10948$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$10949$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[$CellContext`Ose, 
        $CellContext`ParCilindar[$CellContext`x$$, $CellContext`y$$, \
$CellContext`z$$, $CellContext`a$$], PlotRange -> {{-4, 4}, {-4, 4}, {-4, 4}},
         Boxed -> False, Axes -> False], 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, {$CellContext`y$$, 0, 
         1}, {$CellContext`z$$, 0, 1}, {$CellContext`a$$, 2, -2}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{409., {280., 285.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.559628078147359*^9, 3.559628168653536*^9, 
  3.5596290021262074`*^9, 3.5708221539093227`*^9, 3.5708302877375507`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", " ", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{"Ose", ",", 
     RowBox[{"Cilindar", "[", 
      RowBox[{"x", ",", "y", ",", "a", ",", "b"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5596282056876535`*^9, 3.559628207206741*^9}, {
   3.5596282823690395`*^9, 3.559628302199174*^9}, 3.5596284943681655`*^9, {
   3.5708221204974113`*^9, 3.5708221245846453`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 1, $CellContext`b$$ = 
    1, $CellContext`x$$ = 0, $CellContext`y$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 0, 1}, {
      Hold[$CellContext`b$$], 1, 3}, {
      Hold[$CellContext`a$$], 1, 3}}, Typeset`size$$ = {360., {193., 198.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$11033$$ = 0, $CellContext`y$11034$$ = 
    0, $CellContext`b$11035$$ = 0, $CellContext`a$11036$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 1, $CellContext`b$$ = 
        1, $CellContext`x$$ = 0, $CellContext`y$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$11033$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$11034$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$11035$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$11036$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[$CellContext`Ose, 
        $CellContext`Cilindar[$CellContext`x$$, $CellContext`y$$, \
$CellContext`a$$, $CellContext`b$$], PlotRange -> {{-4, 4}, {-4, 4}, {-4, 4}},
         Boxed -> False, Axes -> False], 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, {$CellContext`y$$, 0, 
         1}, {$CellContext`b$$, 1, 3}, {$CellContext`a$$, 1, 3}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{409., {280., 285.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.55962820788978*^9, 3.5596283241474295`*^9, 3.559628374737323*^9, {
   3.5596284225960608`*^9, 3.5596284949511986`*^9}, 3.5596290052383857`*^9, 
   3.5708221565904756`*^9, 3.5708302898636723`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", " ", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{"Ose", ",", 
     RowBox[{"Konus", "[", 
      RowBox[{"x", ",", "y", ",", "z", ",", "a", ",", "b", ",", "c"}], "]"}], 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5596290152079554`*^9, 3.5596290368961964`*^9}, {
   3.5596291186568727`*^9, 3.5596291363768864`*^9}, 3.570822130113961*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 1, $CellContext`b$$ = 
    1, $CellContext`c$$ = 1, $CellContext`x$$ = 0, $CellContext`y$$ = 
    0, $CellContext`z$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 0, 1}, {
      Hold[$CellContext`z$$], 0, 1}, {
      Hold[$CellContext`a$$], 1, 3}, {
      Hold[$CellContext`b$$], 1, 3}, {
      Hold[$CellContext`c$$], 1, 3}}, Typeset`size$$ = {360., {193., 198.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$11114$$ = 0, $CellContext`y$11115$$ = 
    0, $CellContext`z$11116$$ = 0, $CellContext`a$11117$$ = 
    0, $CellContext`b$11118$$ = 0, $CellContext`c$11119$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 1, $CellContext`b$$ = 
        1, $CellContext`c$$ = 1, $CellContext`x$$ = 0, $CellContext`y$$ = 
        0, $CellContext`z$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$11114$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$11115$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$11116$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$11117$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$11118$$, 0], 
        Hold[$CellContext`c$$, $CellContext`c$11119$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[$CellContext`Ose, 
        $CellContext`Konus[$CellContext`x$$, $CellContext`y$$, \
$CellContext`z$$, $CellContext`a$$, $CellContext`b$$, $CellContext`c$$], 
        PlotRange -> {{-4, 4}, {-4, 4}, {-4, 4}}, Boxed -> False, Axes -> 
        False], "Specifications" :> {{$CellContext`x$$, 0, 
         1}, {$CellContext`y$$, 0, 1}, {$CellContext`z$$, 0, 
         1}, {$CellContext`a$$, 1, 3}, {$CellContext`b$$, 1, 
         3}, {$CellContext`c$$, 1, 3}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{409., {307., 312.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.559629026660611*^9, 3.5596290373332214`*^9}, 
   3.5596291368559136`*^9, 3.5708221587175975`*^9, 3.5708302919867935`*^9}]
}, Open  ]]
},
WindowSize->{1904, 945},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 28198, 791, 526, "Input"],
Cell[CellGroupData[{
Cell[28768, 815, 1593, 40, 31, "Input"],
Cell[30364, 857, 3264, 61, 636, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33665, 923, 1264, 33, 31, "Input"],
Cell[34932, 958, 2370, 45, 582, "Output"]
}, Open  ]],
Cell[37317, 1006, 90, 1, 31, "Input"],
Cell[37410, 1009, 92, 1, 31, "Input"],
Cell[CellGroupData[{
Cell[37527, 1014, 1138, 31, 31, "Input"],
Cell[38668, 1047, 2415, 46, 582, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41120, 1098, 1187, 32, 31, "Input"],
Cell[42310, 1132, 2391, 45, 582, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44738, 1182, 1168, 31, 31, "Input"],
Cell[45909, 1215, 2467, 47, 582, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48413, 1267, 1277, 35, 31, "Input"],
Cell[49693, 1304, 2859, 54, 636, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
